require( "HiddenObject/script/style.lua" );

local yes="yes" ;
local yesname="yes" ;
local no="no" ;	
local noname="no" ;	
local name="yesnobox";
	
if (gDialogTable.yeslabel) then
	yes = gDialogTable.yeslabel ;
end
if (gDialogTable.nolabel) then
	no = gDialogTable.nolabel ;
end
if (gDialogTable.yesname) then
	yesname = gDialogTable.yesname;
end
if (gDialogTable.noname) then
	noname = gDialogTable.noname;
end

if (gDialogTable.name) then
	name = gDialogTable.name;
end

YesNoFont = {
  standardFont,
  24,
  WhiteColor
};

FooterGraphics = {
	"HiddenObject/UI/Button/footerbuttonup",
	"HiddenObject/UI/Button/footerbuttondown",
	"HiddenObject/UI/Button/footerbuttonrollover",
};	

SkipHeaderFont = {
  standardFont,
  32,
  Color(131, 167, 184, 255)
};


ButtonFont = {
  standardFont,
  24,
  Color(131, 167, 184, 255)
};

FooterStyle= {
	type = kPush,
	font = ButtonFont,
	flags = kHAlignCenter + kVAlignCenter,
	graphics = FooterGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};

YesNoText =
 {
	parent=DefaultStyle,
	font =YesNoFont,
	flags = kVAlignCenter + kHAlignCenter,
	x=0,y=46,w=kMax,h=kMax-60
};


DialogTitleFont = {
  standardFont,
  26,
  WhiteColor
};



DialogTitleText = {
	parent=DefaultStyle,
	font = DialogTitleFont,
	flags = kVAlignCenter + kHAlignCenter,
	x=16,y=12,w=kMax,h=30
};

MakeDialog
{
	name="skipWindow", -- Remember, this is like saying table['name']=name, so it works.
    Bitmap
    {
		image="HiddenObject/UI/Background/smalldialog",
		x=kCenter,
		y=kCenter - 45,

		SetStyle(DialogTitleText),
        Text
		{
			x = kHAlignCenter;
			y = 20;
			name = "skip",
			label= "skip",
			font = SkipHeaderFont,
			h = 40,
		};
		
		SetStyle(YesNoText),
		Text
		{
			name = "Skipmsg",
			label= "Skipmsg",
		};

        SetStyle(FooterStyle),
        Button
        {
			command=
				function()
					if (gDialogTable.yes) then 
						gDialogTable.yes() ; 
					end
					EnableWindow( "retry_yes", false);
					EnableWindow( "retry_no", false);
					EnableWindow( "pause", false);
					EnableWindow( "go", false);
					EnableWindow( "reveal", false);
					EnableWindow( "skip", false);
					EnableWindow( "ok", false);	
					EnableWindow( "statistics_ok", false);
					EnableWindow( "hint", false);
					SendGameMessage("skip");
				end;
            close = true,
            flags = 5,
            label = yes,
            name = yesname,
            x = kCenter-80,
            y = -75,
        },
        
       -- SetStyle(RightCurveStyle),
        Button
        {
			command=
				function() 
					if (gDialogTable.no) then
						gDialogTable.no() ; 
					end
                end;
            close = true,
            flags = 5,
            label = no,
            name = noname,
            x = kCenter+80,
            y = -75,
        },
    },

} -- MakeDialog
